﻿<%@ Import Namespace="Soneta.Kalend" %>
<%@ Import Namespace="Soneta.Kadry" %>
<%@ Import Namespace="Soneta.Types" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Tools" %>
<%@ Register TagPrefix="cc1" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Page language="c#" AutoEventWireup="false" codePage="1200" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
	<HEAD>
		<title>Urlopy - plan</title>
		<script runat="server">

	public class PrnParams: ContextBase {
	
		public PrnParams(Context context): base(context) {
			UstawRok();
            definicja = KalendModule.GetInstance(this).DefinicjeLimitow.UrlopWypoczynkowy;
		}

        FromTo okres;
        [Caption("Plan urlopów za okres")]
        [Priority(10)]
        public FromTo Okres {
            get { return okres; }
            set {
                if (value == FromTo.Empty || value == FromTo.All)
                    UstawRok();
                else
                    okres = value;
                OnChanged(EventArgs.Empty);
            }
        }

        DefinicjaLimitu definicja;
        [Caption("Nieobecność")]
        [Required]
        [Priority(20)]
        public DefinicjaLimitu Nieobecność {
            get { return definicja; }
            set {
                definicja = value;
                OnChanged(EventArgs.Empty);
            }
        }

        public object GetListNieobecność() {
            DefinicjaLimitu dl;
            Soneta.Business.View view = KalendModule.GetInstance(this).DefinicjeLimitow.WgNazwy.CreateView();
            view.Condition &= new FieldCondition.Equal("Naliczanie", NaliczanieLimitu.WypoczynkowyNaGodziny);
            return view;
        } 
       		
		void UstawRok() {
			Date data;
			if (Context.Contains(typeof(ActualDate)))
				data = ((ActualDate)Context[typeof(ActualDate)]).Actual;
			else
				data = Date.Today;
			okres = FromTo.Year(data.Year);
		}		
	}
	
	PrnParams pars = null; 
	[Context(Required=true)] 
	public PrnParams Params { 
		set { pars = value; } 
	} 

	KalendModule kalend;
	DefinicjaLimitu definicja;
    Log log;    
	
	void OnContextLoad(Object sender, EventArgs args) {
		if (pars.Okres==FromTo.Year(pars.Okres.To.Year))
			ReportHeader1["OKRES"] = "na " + pars.Okres.To.Year + " rok";
		else
			ReportHeader1["OKRES"] = "za okres " + pars.Okres.ToString();
	
		kalend = KalendModule.GetInstance(dc);
		definicja = pars.Nieobecność;

        ReportHeader1["DEFINICJA"] = definicja.Nazwa;

        log = new Log("Wydruk: Urlopy - plan", true);        
	}
	
    void Grid1_BeforeRow(Object sender, RowEventArgs args) {
		PracHistoria ph = (PracHistoria)args.Row;

        if (ph.Etat.RodzajZatrudnienia == RodzajZatrudnienia.PracownikTymczasowy ||
            ph.Etat.RodzajZatrudnienia == RodzajZatrudnienia.PracownikTymczasowyZaGranicą) {
            args.VisibleRow = false;
            if (log != null)
                log.WriteLine("Pracownik " + ph.Pracownik + " został odrzucony - pracownik ma ustawiony rodzaj zatrudnienia jako tymczasowy");
            return;
        }
        
		bool pierwszy = true;
		double dZal = 0;
		Time tZal = Time.Zero;
		decimal dBierz = 0;
		Date data = Date.Empty;
		Time tBierz = Time.Zero;
        Time kBierz = Time.Zero;
		Time tPoz = Time.Zero;
		double dPoz = 0;
		
		IEnumerable limity = kalend.LimNieobecnosci.WgPracownik[ph.Pracownik, definicja][pars.Okres];
        foreach (LimitNieobecnosci l in limity) {
            if (pierwszy) {
                pierwszy = false;
                if (l.Przeniesienie != 0)
                    dZal = l.Przeniesienie;
                else {
                    tZal = l.PrzeniesienieGodz;
                    data = l.Okres.To;
                }
            }

            if (l.Typ == TypLimituNieobecności.UrlopWypoczynkowy)
                dBierz += l.PodstawaGodz;       //TID: 2052
            else
                dBierz += l.Limit + l.Zmiana + l.Korekta;
            tBierz += l.LimitGodz;
            kBierz += l.ZmianaGodz - l.WykorzystanyPoprzGodz;
            tPoz = l.PozostaloGodz;
            dPoz = l.PozostaloDni;
        }	
		
		if (tZal!=Time.Zero) {
            Fraction wymiar = ph.Pracownik[data].Etat.Wymiar;
            if (wymiar==Fraction.Zero)
                wymiar = Fraction.One;

            Time norma = ph.Pracownik[data].Etat.Kalendarz.NormaDobowa;
            if (norma==Time.Zero)
                norma = new Time(8, 0);
                
            dZal = Soneta.Tools.Math.Round(tZal / norma / wymiar, 2);
		}
		
		zaległyD.EditValue = dZal;
		zaległyG.EditValue = tZal;
		limitD.EditValue = (double)dBierz;
		limitG.EditValue = tBierz;
        limitK.EditValue = kBierz;
		resztaG.EditValue = tPoz;
		resztaD.EditValue = Soneta.Tools.Math.RoundCy(dPoz);

		KalkulatorPracy kalk = new KalkulatorPracy(ph.Pracownik);
		IEnumerable nieobecności = kalk.Nieobecnosci(pars.Okres, true);
		ArrayList result = new ArrayList();
		foreach (OkresNieobecności n in nieobecności)
			if (n.Definicja.Limit==definicja)
				result.Add(n);

		string s14 = "";
		string sp = "";
		string sd = "";
		foreach (OkresNieobecności n in result) {
			if (n.Okres.Days>=14) {
				s14 += "<br>" + n.Okres;
				sp += "<br>";				
			}
			else {
				s14 += "<br>";				
				sp += "<br>" + n.Okres;
 			}
 			sd += "<br>" + n.Norma().Czas;
 		}
		termin14.EditValue = s14=="" ? "" : s14.Substring(4, s14.Length-4);
		termin.EditValue = sp=="" ? "" : sp.Substring(4, sp.Length-4);
		urlopG.EditValue = sd=="" ? "" : sd.Substring(4, sd.Length-4);
    }
    
	public static object Msg(object obj) {
		return obj;
	}

		</script>
		<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
		<meta content="Microsoft Visual Studio 7.0" name="GENERATOR">
		<meta content="C#" name="CODE_LANGUAGE">
		<meta content="JavaScript" name="vs_defaultClientScript">
		<meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
	</HEAD>
	<body>
		<form id="UrlopyPlan" method="post" runat="server">
			<ea:datacontext id="dc" runat="server" LeftMargin="-1" TypeName="Soneta.Business.Row[], Soneta.Business"
				oncontextload="OnContextLoad" Landscape="True"></ea:datacontext>
            <cc1:reportheader NagłówekOddziału="NagłówekOddziału" id="ReportHeader1" 
                title="Plan urlopów %OKRES%|&lt;/strong&gt;Definicja: &lt;strong&gt; %DEFINICJA%" 
                runat="server"></cc1:reportheader><ea:grid id="Grid1" runat="server" OnBeforeRow="Grid1_BeforeRow" RowTypeName="Soneta.Kadry.PracHistoria, Soneta.KadryPlace"
				LinkedRows="History">
				<Columns>
					<ea:GridColumn Width="4" Align="Right" DataMember="#" Caption="LP." ID="lp" runat="server"></ea:GridColumn>
					<ea:GridColumn Width="20" DataMember="Etat.Wydzial.Kod" Caption="Nazwa działu zakładu pracy" NoWrap="True" runat="server" EncodeHTML="true"></ea:GridColumn>
					<ea:GridColumn DataMember="Pracownik.NazwiskoImię" Caption="Nazwisko i imię pracownika" NoWrap="True" runat="server"></ea:GridColumn>
					<ea:GridColumn Width="7" Align="Center" Caption="Zaległy urlop~dni" HideZero="True" ID="zaległyD" runat="server"></ea:GridColumn>
					<ea:GridColumn Width="7" Align="Center" Caption="Zaległy urlop~godz." HideZero="True" ID="zaległyG" runat="server"></ea:GridColumn>
					<ea:GridColumn Width="7" Align="Center" Caption="Limit urlopu~dni wg. kp" HideZero="True" ID="limitD" runat="server"></ea:GridColumn>
					<ea:GridColumn Width="7" Align="Center" Caption="Limit urlopu~godz." HideZero="True" ID="limitG" runat="server"></ea:GridColumn>
                    <ea:GridColumn ID="limitK" runat="server" Align="Center" Caption="Limit urlopu~korekta godz."
                        HideZero="True" Width="7">
                    </ea:GridColumn>
					<ea:GridColumn Width="21" Caption="Planowany termin&lt;br&gt;(co najmniej 14 dni)" HideZero="True"
						ID="termin14" VAlign="Top" runat="server"></ea:GridColumn>
					<ea:GridColumn Width="21" Caption="Planowany termin&lt;br&gt;(pozostałe)" HideZero="True" ID="termin"
						VAlign="Top" runat="server"></ea:GridColumn>
					<ea:GridColumn Width="7" Align="Center" Caption="Liczba godz. urlopu" HideZero="True" ID="urlopG"
						VAlign="Top" runat="server"></ea:GridColumn>
					<ea:GridColumn Width="7" Align="Center" Caption="Pozostało~dni wg. etatu" HideZero="True" ID="resztaD" runat="server"></ea:GridColumn>
					<ea:GridColumn Width="7" Align="Center" Caption="Pozostało~godz." HideZero="True" ID="resztaG" runat="server"></ea:GridColumn>
				</Columns>
			</ea:grid><cc1:reportfooter id="ReportFooter1" runat="server"></cc1:reportfooter></form>
	</body>
</HTML>
